alter table sys_employee_org
    add column assignee bit default 0 comment '是否负责人';
alter table sys_org
    add column sync_outer bit default 1 comment '是否向外同步';

-- `cloudt3-system`.sys_sync definition
CREATE TABLE `sys_sync`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `data_type`          varchar(255) NOT NULL COMMENT '数据类型',
    `data_key`           varchar(255) DEFAULT NULL COMMENT '数据的唯一标识',
    `sync_outer`         bit(1)       DEFAULT NULL COMMENT '是否是向外同步',
    `outer_app`          varchar(255) NOT NULL COMMENT '外部系统标识',
    `outer_data_key`     varchar(255) DEFAULT NULL COMMENT '外部数据的唯一标识',
    `sync_data_time`     datetime(6)  DEFAULT NULL COMMENT '同步时间',
    `manual`             bit(1)       DEFAULT NULL COMMENT '是否手工同步',
    `sync_success`       bit(1)       DEFAULT b'0' COMMENT '是否同步成功',
    `fail_reason`        longtext COMMENT '同步失败原因',
    `attr`               longtext COMMENT '扩展信息',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sync_datatype` (`data_type`),
    KEY `idx_sync_datakey` (`data_key`),
    KEY `idx_sync_outerdatakey` (`outer_data_key`),
    KEY `idx_sync_synctime` (`sync_data_time`)
) COMMENT ='同步信息';